function [fusion_times, VSout, time] = directMethod_SingleSyt_Casignal1(VS0, par, Casignal, evalVes, steadyIO, varNsytIO)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%This function computes vesicle fusion times following the gillespie
%algorithm. It allows for variation in number of syts

%Inputs
%VS0 - steady state matrix
%par - model parameters (see list below)
%Casignal - matrix with Ca2+ transient and the corresponding time
%evalVes - number of vesicle fusions to evaluate
%SteadyIO - 1 run to test if steady state is reached.
%varNsytIO - 1 for variable syt number per vesicle

%Outputs
%Fusion_times - Fusion time points of SVs
%VSout - Final state of the synaptotagmins
%time - Timesteps taken.

% Initialize
MAX_OUTPUT_LENGTH = 1e7;
%samplingrate = 22e3;
n=size(VS0,1); %no Syts
ves=size(VS0,2); %no ves.
T = 0;

%numEval = 50;

VSout = VS0;

k_onCa = par(1);
KD = par(2);
k_onPIP2 = par(3);
PIP2 = par(4);
c = par(5);
l = par(6);
f = par(7);
nsyt = par(8);
maxcross = par(9);
cacoop = par(10);
maxCa = par(11);
KD_pip = par(12);


Time_ca = Casignal(:,1);
Calcium = Casignal(:,2);
CaIP = Calcium(1);

alpha = CaIP^cacoop * k_onCa;
beta = KD*k_onCa;
gamma = PIP2 * k_onPIP2;
delta = KD_pip*k_onPIP2; %%% ops: KD for PIP2 different than for Ca2+!!!

transitions = [1, 10, -1, -10];
fusion_times = NaN(evalVes, 1);
%fusion_times = NaN(evalVes, 1);
rxn_count = 1; %Reaction counter
fused_ves = 0;%fusion_count = 0;

time = 0;


%% MAIN LOOP

%get number of syts for each vesicle
if varNsytIO
    nsyt= max(varNsytIO);
    VSout = VSout(1:nsyt, :);
    n=nsyt;
end
VSin=VSout;

PIPbound = repmat(sum(VSin==11 | VSin==1,1), nsyt, 1);

if varNsytIO
    b = repmat([1:nsyt]',1,ves); 
    z= b<=varNsytIO;
else 
    z = ones(nsyt, ves);
end

maxcross = ones(1, ves)*maxcross;

%compute propensity matrix
a_1 = z.*((VSin==0).*((max(maxcross-PIPbound,0)).*gamma) + (VSin==1).*(delta) + (VSin==10).*(beta+(max(maxcross-PIPbound,0)).*gamma) + (VSin==11).*(delta*c+beta*c)...
+((VSin==0)+(VSin ==1)).*alpha + (VSin  ==1).*(delta));
a_2 = l.*f.^sum((VSin==11).*z,1);


%a_2 = l.*f.^(VSin==11);
a = vertcat(a_1,a_2);
a0 = sum(sum(a,1));


while ((rxn_count < 1e4 && steadyIO == 1)||(T < Time_ca(end) && steadyIO ==0))
    VSin=VSout;
    
    if a0 > 0 %Make sure there are still releaseable vesicles    
        r = rand(1,4);
        tau = (1/a0)*log(1/r(1));
        
        if tau > 8e-6
        T= T+8e-6;
        else
        ves_ind  = find((cumsum(sum(a,1)) >= r(2)*a0),1,'first'); % Determine vesicle number

         %%%%%%Carry out reaction
        %determine reaction of vesicle
        syt_ind = find((cumsum(a(:,ves_ind)) >= r(3)*sum(a(:,ves_ind))),1,'first'); % Determine reaction number;
        if syt_ind == n+1 %Fusion reaction
            fused_ves = fused_ves+1;
            fusion_times(fused_ves)=T;
            VSout=VSin;
            VSout(:,ves_ind)=-1;
           
            
        else %Binding/unbinding reaction
                a_react = [(1-mod(VSin(syt_ind,ves_ind),10))*gamma*max(maxcross(ves_ind) - PIPbound(syt_ind, ves_ind),0),...
                    (1-floor(VSin(syt_ind,ves_ind)/10))*alpha, mod(VSin(syt_ind,ves_ind),10)*delta*c^floor(VSin(syt_ind,ves_ind)/10), ...
                    floor(VSin(syt_ind,ves_ind)/10)*beta*c^mod(VSin(syt_ind,ves_ind),10)];
           
                reaction_type = find((cumsum(a_react) >= r(4)*sum(a_react)),1,'first'); % Determine reaction number;
            
                VSout=VSin;
            
                VSout(syt_ind,ves_ind) = VSin(syt_ind,ves_ind)+transitions(reaction_type); % carry out reaction
            
            %update PIP bound
           
            PIPbound(:, ves_ind) = repmat(sum(VSout(:, ves_ind)==11 | VSout(:, ves_ind)==1,1), nsyt, 1);
            
        end
        T   = T  + tau;
        rxn_count = rxn_count + 1;
        end
        
        %Update calcium concentration and propensity matrix
        ca = interp1(Time_ca , Calcium, T);
        alpha = ca^cacoop * k_onCa;
           
            a(1:n, :) = z.*((VSout==0).*(gamma.*max(maxcross- PIPbound, 0)) ...
               + (VSout ==1).*delta  ...
               + (VSout ==10).*(beta+gamma.*max(maxcross - PIPbound, 0)) ... 
               + (VSout ==11).*c.*(delta+beta)...
               + ((VSout== 0) + (VSout ==1)).*alpha); 
    
    
        a(n+1,:) = l.*f.^sum((VSin==11).*z,1);
        a0= sum(sum(a));
        
%           
        
        %time = [time, T];
      
     else %If all R-vesicles have fused
        %T   = tspan(2);
        VSout = VSin;
        rxn_count = rxn_count + 1;
    end
end


%toc
